@echo off
setlocal enabledelayedexpansion

:: Set console properties
color 0A
title SHA-256 Password Hasher

echo ========================================
echo       SHA-256 Password Hasher
echo ========================================
echo.

:: Prompt for password/PIN
set /p "password=Enter your password or PIN: "

:: Check if password is empty
if "!password!"=="" (
    echo.
    echo Error: Password cannot be empty!
    pause
    exit /b 1
)

echo.
echo Processing...
echo.

:: Create temporary file with password
set "tempFile=%temp%\hash_input_%random%.txt"
echo !password!> "!tempFile!"

:: Use PowerShell to calculate SHA-256 hash
for /f "delims=" %%i in ('powershell -Command "$content = Get-Content '!tempFile!' -Raw; $content = $content.TrimEnd([char]13, [char]10); $hash = [System.Security.Cryptography.SHA256]::Create(); $bytes = [System.Text.Encoding]::UTF8.GetBytes($content); $hashBytes = $hash.ComputeHash($bytes); [System.BitConverter]::ToString($hashBytes).Replace('-', '').ToLower()"') do set "hash=%%i"

:: Clean up temporary file
del "!tempFile!" >nul 2>&1

:: Display results
echo ========================================
echo              RESULTS
echo ========================================
echo.
echo Password/PIN: !password!
echo.
echo SHA-256 Hash:
echo !hash!
echo.
echo ========================================
echo.
echo Press any key to close...
pause >nul
